// AnimationFactoryDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AnimationFactory.h"
#include "AnimationFactoryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimationFactoryDlg dialog

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CAnimationFactoryDlg * g_pAnimationFactoryDlg = NULL;

QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	g_pAnimationFactoryDlg->m_nDeviceVideoWidth = 0;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeight = 0;

	g_pAnimationFactoryDlg->m_bDeviceVideoIsInterleaved = FALSE;

	g_pAnimationFactoryDlg->m_dDeviceVideoFrameRate = 0.0;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannel = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSample = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequency = 0;

	SC_DEBUG( "on_no_signal_detected_callback()" );

	g_pAnimationFactoryDlg->SetTimer( 0x00000000, 1, NULL );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	g_pAnimationFactoryDlg->m_nDeviceVideoWidth = 0;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeight = 0;

	g_pAnimationFactoryDlg->m_bDeviceVideoIsInterleaved = FALSE;

	g_pAnimationFactoryDlg->m_dDeviceVideoFrameRate = 0.0;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannel = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSample = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequency = 0;

	SC_DEBUG( "on_no_signal_removed_callback()" );

	g_pAnimationFactoryDlg->SetTimer( 0x00000000, 1, NULL );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	g_pAnimationFactoryDlg->m_nDeviceVideoWidth = nVideoWidth;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeight = nVideoHeight;

	g_pAnimationFactoryDlg->m_bDeviceVideoIsInterleaved = bVideoIsInterleaved;

	g_pAnimationFactoryDlg->m_dDeviceVideoFrameRate = dVideoFrameRate;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannel = nAudioChannels;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSample = nAudioBitsPerSample;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequency = nAudioSampleFrequency;

	SC_DEBUG( "on_format_changed_callback( %d, %d, %d, %2.3f, %d, %d, %d )", nVideoWidth, nVideoHeight, bVideoIsInterleaved, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );
	
	g_pAnimationFactoryDlg->SetTimer( 0x00000000, 1, NULL );

	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	if( g_pAnimationFactoryDlg->m_nStartChatState >= 0x00000001 ) {

		QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( g_pAnimationFactoryDlg->m_pSender, 
			
															  0, 
															  
															  QCAP_COLORSPACE_TYEP_YV12, 
			
															  g_pAnimationFactoryDlg->m_nDeviceVideoWidth, 
															  
															  g_pAnimationFactoryDlg->m_nDeviceVideoHeight, 
															  
															  pFrameBuffer,
															  
															  nFrameBufferLen );
	}
    return QCAP_RT_OK;
}

QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	if( g_pAnimationFactoryDlg->m_nStartChatState >= 0x00000001 ) {

		QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( g_pAnimationFactoryDlg->m_pSender, 
			
															  0, 
															  
															  pFrameBuffer,
															  
															  nFrameBufferLen );
	}
    return QCAP_RT_OK;
}

CAnimationFactoryDlg::CAnimationFactoryDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAnimationFactoryDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAnimationFactoryDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAnimationFactoryDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnimationFactoryDlg)
	DDX_Control(pDX, IDC_STATIC_SHARE_WINDOW, m_statShareWindow);
	DDX_Control(pDX, IDC_STATIC_LIVE_WINDOW, m_statLiveWindow);
	DDX_Control(pDX, IDC_STATIC_INFO, m_strDeviceInfo);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAnimationFactoryDlg, CDialog)
	//{{AFX_MSG_MAP(CAnimationFactoryDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_CONNECT, OnButtonConnect)
	ON_BN_CLICKED(IDC_BUTTON_DISCONNECT, OnButtonDisconnect)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimationFactoryDlg message handlers

extern CAnimationFactoryApp theApp;

void CAnimationFactoryDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	KillTimer( 0x00000000 );

	m_nStartChatState = 0x00000000;

	if( m_pChatter ) {

		QCAP_DESTROY_WEBRTC_CHATTER( m_pChatter );

		m_pChatter = NULL;
	}
	if( m_pSender ) {

		QCAP_STOP_BROADCAST_SERVER( m_pSender );

		QCAP_DESTROY_BROADCAST_SERVER( m_pSender );

		m_pSender = NULL;
	}
	if( m_pReceiver ) {

		QCAP_STOP_BROADCAST_CLIENT( m_pReceiver );

		QCAP_DESTROY_BROADCAST_CLIENT( m_pReceiver );

		m_pReceiver = NULL;
	}
	// UNINITIALIZE DEVICE RESOURCE
	// 
	if( m_pDevice ) {

		QCAP_STOP( m_pDevice );

		QCAP_DESTROY( m_pDevice );

		m_pDevice = NULL;
	}
	UpdateData( TRUE );

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

extern ULONG g_n_app_instance;

BOOL CAnimationFactoryDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM LIBRARY
	// 
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE DEVICE RESOURCE
	// 
	g_pAnimationFactoryDlg = this;

	m_pDevice = NULL;

	m_nDeviceVideoWidth = 0;

	m_nDeviceVideoHeight = 0;

	m_bDeviceVideoIsInterleaved = FALSE;

	m_dDeviceVideoFrameRate = 0.0;

	m_nDeviceAudioChannel = 0;

	m_nDeviceAudioBitsPerSample= 0;

	m_nDeviceAudioSampleFrequency = 0;

	m_pChatter = NULL;

	m_pSender = NULL;

	m_pReceiver = NULL;

	m_nStartChatState = 0x00000000;

	UpdateData( FALSE );

	// INITIALIZE DEVICE RESOURCE
	// 
	QCAP_CREATE( "QP0203 PCI", 0, m_statLiveWindow.m_hWnd, &m_pDevice, TRUE, FALSE );

//	QCAP_CREATE( "CY3014 USB", 0, m_statLiveWindow.m_hWnd, &m_pDevice, TRUE, FALSE );

//	QCAP_CREATE( "CAMERA", 0, m_statLiveWindow.m_hWnd, &m_pDevice, TRUE, FALSE );

	QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevice, on_format_changed_callback, this );

	QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevice, on_no_signal_detected_callback, this );

	QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevice, on_no_signal_removed_callback, this );

	QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice, on_video_preview_callback, this );

	QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice, on_audio_preview_callback, this );

	QCAP_SET_AUDIO_VOLUME( m_pDevice, 0 );

	QCAP_RUN( m_pDevice );

	CHAR psz[ MAX_PATH ];

	sprintf( psz, "account#%02d", g_n_app_instance + 1 );

	QCAP_CREATE_WEBRTC_CHATTER( "127.0.0.1", 8888, psz, &m_pChatter, &m_chatter_id  );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAnimationFactoryDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAnimationFactoryDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAnimationFactoryDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAnimationFactoryDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CAnimationFactoryDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CAnimationFactoryDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000000 ) {

		KillTimer( 0x00000000 );

		if( m_nDeviceVideoWidth == 0 ||

			m_nDeviceVideoHeight == 0 ) {

			m_strDeviceInfo.SetWindowText( "INFO: ..." );
		}
		else {

			CString m_strFormatChangedOutput;

			m_strFormatChangedOutput.Format( "INFO: %d X %d%c @ %2.3f, %d X %d X %d", m_nDeviceVideoWidth, 
				
																					  m_nDeviceVideoHeight, 
																					  
																					  m_bDeviceVideoIsInterleaved ? 'I' : 'P', 
																					  
																					  m_dDeviceVideoFrameRate, 
																					  
																					  m_nDeviceAudioChannel, 
																					  
																					  m_nDeviceAudioBitsPerSample, 
																					  
																					  m_nDeviceAudioSampleFrequency );

			m_strDeviceInfo.SetWindowText( (LPCTSTR)(m_strFormatChangedOutput) );

			if( m_pReceiver == NULL ) {

				QCAP_CREATE_WEBRTC_RECEIVER( m_pChatter, 0, &m_pReceiver, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, m_statShareWindow.m_hWnd, TRUE, FALSE );

				if( m_pReceiver ) {

					QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME( m_pReceiver, 0, 100 );

					QCAP_START_BROADCAST_CLIENT( m_pReceiver );
				}
			}
			if( m_pSender == NULL ) {

				QCAP_CREATE_WEBRTC_SENDER( m_pChatter, 0, &m_pSender );

				if( m_pSender ) {

					ULONG        cx = m_nDeviceVideoWidth;
		
					ULONG        cy = m_nDeviceVideoHeight;
		
					double      fps = m_dDeviceVideoFrameRate; if( m_bDeviceVideoIsInterleaved ) { fps /= 2; }
		
					ULONG  channels = m_nDeviceAudioChannel;
		
					ULONG      bits = m_nDeviceAudioBitsPerSample;
		
					ULONG      freq = m_nDeviceAudioSampleFrequency;

					QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_pSender, 
						
															  0, 
															 
															  QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, 
															  
															  QCAP_ENCODER_FORMAT_H264, 
															  
															  QCAP_COLORSPACE_TYEP_YV12, 
															  
															  cx, 
															  
															  cy,
															  
															  fps, 
															  
															  QCAP_RECORD_MODE_CBR, 
															  
															  8000, 
															  
															  3000000, 
															  
															  30,  
															  
															  0,  0, 
															  
															  NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );

					QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_pSender, 
						
															  0, 
															  
															  QCAP_ENCODER_TYPE_SOFTWARE, 
															  
															  QCAP_ENCODER_FORMAT_PCM, 
															  
															  channels, 
															  
															  bits, 
															  
															  freq );
					QCAP_START_BROADCAST_SERVER( m_pSender );
				}
				m_nStartChatState = 0x00000001;
			}
		}
	}
	CDialog::OnTimer(nIDEvent);
}

void CAnimationFactoryDlg::OnButtonConnect() 
{
	// TODO: Add your control notification handler code here

	if( m_pChatter && 
		
		m_pSender && 
		
		m_pReceiver ) {

		ULONG n_1st_peer_id = 0;

		ULONG n_peer_id = 0;

		CHAR  *psz_peer_name;

		QRESULT returns = QCAP_ENUM_WEBRTC_USER_IN_CHATROOM( m_pChatter, &n_peer_id, &psz_peer_name, FALSE );

		SC_DEBUG( "%d, %d, %s", returns, n_peer_id, psz_peer_name );

		n_1st_peer_id = n_peer_id;

		while( returns == QCAP_RS_SUCCESSFUL ) {

			returns = QCAP_ENUM_WEBRTC_USER_IN_CHATROOM( m_pChatter, &n_peer_id, &psz_peer_name, TRUE );
		
			SC_DEBUG( "%d, %d, %s", returns, n_peer_id, psz_peer_name );
		}
		QCAP_START_WEBRTC_CHAT( m_pChatter, n_1st_peer_id );
	}	
}

void CAnimationFactoryDlg::OnButtonDisconnect() 
{
	// TODO: Add your control notification handler code here
	
	if( m_pChatter ) {

		QCAP_STOP_WEBRTC_CHAT( m_pChatter );
	}
}
